﻿using Dapper;
using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.DashBoards
{
    public class DatosGraficas
    {
        public string Etiqueta { get; set; }
        public int Valor { get; set; }
    }
    
    
    
    public class DatosAvance 
    {
        public string CicloEscolar { get; set; }
        public int Universo { get; set; }
        public int TotalEvaluados { get; set; }
        public int TotalContratados { get; set; }
        public decimal PorcentajeEvaluados { get; set; }
        public decimal PorcentajeContratados { get; set; }
        
    }

     
    public class GraficasContratacion
    {
        public List<DatosGraficas> ObtenDatosPorEncuesta()
        {
            bdNovaEntities bd = new bdNovaEntities();

            var config = bd.Nomina_ContratosConfiguracion.Where(a => a.EsVigente == true).FirstOrDefault();



            string query = $@"select Pregunta as Etiqueta,AVG(respuesta) as Valor from (
SELECT Pregunta,Respuesta*2 as Respuesta
FROM  dbo.Kardex_PreguntaAdicionalContratoRespuesta AS a INNER JOIN
               dbo.Kardex_PreguntaAdicionalContrato AS b ON a.IdKardexPreguntaAdicionalContrato = b.IdKardexPreguntaAdicionalContrato INNER JOIN
               dbo.Kardex_KardexEncuesta AS c ON b.IdKardexEncuesta = c.IdKardexEncuesta INNER JOIN
               dbo.Kardex_ctDatosPersonales ON a.IdKardex = dbo.Kardex_ctDatosPersonales.IdKardex 
               where b.IdKardexEncuesta=3 and b.IdKardexPreguntaAdicionalContrato not in (9,10,11)
               ) as q
               group by Pregunta";


            DapperQuery dp = new DapperQuery("bdNovaEntities");



            List<DatosGraficas> datos = (List<DatosGraficas>)dp.connection.Query<DatosGraficas>(query.ToString()).ToList().AsEnumerable();

            dp.Close();
            return datos;

        }

        public List<DatosGraficas> ObtenDatosPorTiempoAtencion()
        {
            bdNovaEntities bd = new bdNovaEntities();

            var config = bd.Nomina_ContratosConfiguracion.Where(a => a.EsVigente == true).FirstOrDefault();

           

            string query = $@"select RelacionLaboral as Etiqueta,avg(difmin) Valor from  (
select r.RelacionLaboral ,a.IdKardexSolicitudEvaluacion,a.Fecha,b.Fecha as FechaTermino,
DATEDIFF(MINUTE,a.Fecha,b.Fecha) as difmin,
DATEDIFF(MINUTE,a.Fecha,b.Fecha) / 60 as horas,
DATEDIFF(MINUTE,a.Fecha,b.Fecha) % 60 as minutos
 from 
(SELECT  i.IdKardexSolicitudEvaluacion,i.IdEstatusContratacion,MAX(i.Fecha) as Fecha
  FROM [Kardex_SolicitudEvaluacionesEstatus] i 
  where IdEstatusContratacion=8
  group by i.IdKardexSolicitudEvaluacion,i.IdEstatusContratacion) as a
  left join (
  SELECT   i.IdKardexSolicitudEvaluacion,i.IdEstatusContratacion,MAX(i.Fecha) as Fecha
  FROM [Kardex_SolicitudEvaluacionesEstatus] i 
  where IdEstatusContratacion=6
  group by i.IdKardexSolicitudEvaluacion,i.IdEstatusContratacion ) as b 
  on a.IdKardexSolicitudEvaluacion=b.IdKardexSolicitudEvaluacion
   inner join Kardex_SolicitudEvaluaciones s on s.IdKardexSolicitudEvaluacion=a.IdKardexSolicitudEvaluacion
   inner join Catalogos_ctRelacionLaboral r on r.IdRelacionLaboral=s.IdRelacionLaboral
   where replace(s.CicloEscolar,' ','')='{config.CicloEscolar}'
  ) as q
  group by RelacionLaboral";


            DapperQuery dp = new DapperQuery("bdNovaEntities");



            List<DatosGraficas> datos = (List<DatosGraficas>)dp.connection.Query<DatosGraficas>(query.ToString()).ToList().AsEnumerable();

            dp.Close();
            return datos;

        }
        public List<DatosGraficas> ObtenDatosPorEstatus()
        {
            bdNovaEntities bd = new bdNovaEntities();

            var config = bd.Nomina_ContratosConfiguracion.Where(a => a.EsVigente == true).FirstOrDefault();

            //            string query = $@"select c.EstatusContratos as Etiqueta ,count(*) as Valor from Kardex_SolicitudEvaluaciones a
            //--inner join Kardex_SolicitudEvaluacionesEstatus b on a.IdKardexSolicitudEvaluacion=b.IdKardexSolicitudEvaluacion
            //inner join Catalogos_ctEstatusContratos c on c.IdEstatusContratos=a.IdEstatusContratacion
            //where a.CicloEscolar='{config.CicloEscolar}'
            //group by CicloEscolar,c.EstatusContratos ";


            string query = $@" select  a.EstatusContratos as Etiqueta, ISNULL(Total,0) as Valor from Catalogos_ctEstatusContratos a
 left join (

select Estatus.IdEstatusContratos, EstatusContratos, COUNT(Sexo) AS Total
from (
select  max(IdEstatusContratos) as IdEstatusContratos, a.IdKardexSolicitudEvaluacion,IdKardexCandidato
,max(b.Sexo) as Sexo
from Kardex_SolicitudEvaluaciones a
inner join vwDatosAspirantesTrabajadores b on a.IdKardexCandidato=b.IdKardex and a.CicloEscolar='{config.CicloEscolar}'
inner join Kardex_SolicitudEvaluacionesEstatus c on c.IdKardexSolicitudEvaluacion=a.IdKardexSolicitudEvaluacion
inner join Catalogos_ctEstatusContratos d on d.IdEstatusContratos=c.IdEstatusContratacion
 group by a.IdKardexSolicitudEvaluacion,IdKardexCandidato
 ) as Estatus
 inner join Catalogos_ctEstatusContratos b on Estatus.IdEstatusContratos=b.IdEstatusContratos
   GROUP BY Estatus.IdEstatusContratos,EstatusContratos
) as Universo on a.IdEstatusContratos=Universo.IdEstatusContratos
order by a.Orden asc";


            DapperQuery dp = new DapperQuery("bdNovaEntities");



            List<DatosGraficas> datos = (List<DatosGraficas>)dp.connection.Query<DatosGraficas>(query.ToString()).ToList().AsEnumerable();

            dp.Close();
            return datos;

        }
        public List<DatosGraficas> ObtenDatosPorAreaConocimientoCategoria()
        {
            bdNovaEntities bd = new bdNovaEntities();

            var config = bd.Nomina_ContratosConfiguracion.Where(a => a.EsVigente == true).FirstOrDefault();

          

            string query =  $@"
                select c.AreaConocimiento as Etiqueta,count(b.Sexo) as Valor
from Kardex_SolicitudEvaluaciones a
inner join vwDatosAspirantesTrabajadores b on a.IdKardexCandidato=b.IdKardex and a.CicloEscolar='{config.CicloEscolar}'
inner join Kardex_ctAreaConocimiento c on a.IdAreaConocimiento=c.IdAreaConocimiento
inner join Plazas_ctCategoria bb on bb.IdCategoria=a.IdCategoriaAspirante
inner join Convenios_stRelacionConvenioLaboral d on d.IdRelacionConvenioLaboral=bb.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral e on e.IdConvenioLaboral=d.IdConvenioLaboral
group by e.ConvenioLaboral,AreaConocimiento
order by 2 desc,1
                            " ;


            DapperQuery dp = new DapperQuery("bdNovaEntities");



            List<DatosGraficas> datos = (List<DatosGraficas>)dp.connection.Query<DatosGraficas>(query.ToString()).ToList().AsEnumerable();

            dp.Close();
            return datos;

        }

        public DatosAvance ObtenDatosAvanceAdministrativo()
        {
            bdNovaEntities bd = new bdNovaEntities();
            var config = bd.Nomina_ContratosConfiguracion.Where(a => a.EsVigente == true).FirstOrDefault();
            string query = $@"
                  declare @cicloEscolar as nvarchar(10) 
                    set @cicloEscolar='{config.CicloEscolar}'
                    select CicloEscolar,Universo,TotalEvaluados,TotalContratados
                    ,PorcentajeEvaluados= cast(case when TotalEvaluados > 0 then (cast(TotalEvaluados as decimal)/cast(Universo as decimal))*100 else 0 end as decimal(18,2))
                    ,PorcentajeContratados=cast(case when TotalContratados > 0 then (cast(TotalContratados as decimal)/cast(Universo as decimal))*100 else 0 end as decimal(18,2))
                    from 
                        (select CicloEscolar, 
			                    count(*) as Universo
			                    from Kardex_SolicitudEvaluaciones
			                    where IdRelacionLaboral=2 and CicloEscolar=@cicloEscolar
			                    group by CicloEscolar) as A
				                    cross join (
							                    select count(IdKardexCandidato) as TotalEvaluados 
								                    from (
									                    select CicloEscolar,a.IdKardexCandidato
									                    from Kardex_SolicitudEvaluaciones a
									                    inner join Kardex_SolicitudEvaluacionesEstatus c on c.IdKardexSolicitudEvaluacion=a.IdKardexSolicitudEvaluacion
									                    inner join Catalogos_ctEstatusContratos d on d.IdEstatusContratos=c.IdEstatusContratacion
									                    where a.IdRelacionLaboral=2 and d.EstatusContratos in ('NO ACEPTABLE','ACEPTABLE') and a.CicloEscolar=@cicloEscolar
									                    group by CicloEscolar,a.IdKardexCandidato
									                    ) as Evaluados
						                    ) as B
				                    cross join (
							                    select  count(IdKardexCandidato) as TotalContratados 
							                    from (
								                       select CicloEscolar,a.IdKardexCandidato
									                    from Kardex_SolicitudEvaluaciones a
									                    inner join Kardex_SolicitudEvaluacionesEstatus c on c.IdKardexSolicitudEvaluacion=a.IdKardexSolicitudEvaluacion
									                    inner join Catalogos_ctEstatusContratos d on d.IdEstatusContratos=c.IdEstatusContratacion
									                    where a.IdRelacionLaboral=2 and  d.EstatusContratos in ('CONTRATADO') and a.CicloEscolar=@cicloEscolar
									                    group by CicloEscolar,a.IdKardexCandidato
								                    ) as Contratados
							                    ) as C
                            ";
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            DatosAvance datos = (DatosAvance)dp.connection.QuerySingle<DatosAvance>(query);
            dp.Close();
            return datos;
        }
        public DatosAvance ObtenDatosAvanceDocente()
        {
            bdNovaEntities bd = new bdNovaEntities();
            var config = bd.Nomina_ContratosConfiguracion.Where(a => a.EsVigente == true).FirstOrDefault();
            string query = $@"
                  declare @cicloEscolar as nvarchar(10) 
                    set @cicloEscolar='{config.CicloEscolar}'
                    select CicloEscolar,Universo,TotalEvaluados,TotalContratados
                    ,PorcentajeEvaluados= cast(case when TotalEvaluados > 0 then (cast(TotalEvaluados as decimal)/cast(Universo as decimal))*100 else 0 end as decimal(18,2))
                    ,PorcentajeContratados=cast(case when TotalContratados > 0 then (cast(TotalContratados as decimal)/cast(Universo as decimal))*100 else 0 end as decimal(18,2))
                    from 
                        (select CicloEscolar, 
			                    count(*) as Universo
			                    from Kardex_SolicitudEvaluaciones
			                    where IdRelacionLaboral=1 and CicloEscolar=@cicloEscolar
			                    group by CicloEscolar) as A
				                    cross join (
							                    select count(IdKardexCandidato) as TotalEvaluados 
								                    from (
									                    select CicloEscolar,a.IdKardexCandidato
									                    from Kardex_SolicitudEvaluaciones a
									                    inner join Kardex_SolicitudEvaluacionesEstatus c on c.IdKardexSolicitudEvaluacion=a.IdKardexSolicitudEvaluacion
									                    inner join Catalogos_ctEstatusContratos d on d.IdEstatusContratos=c.IdEstatusContratacion
									                    where a.IdRelacionLaboral=1 and d.EstatusContratos in ('NO ACEPTABLE','ACEPTABLE') and a.CicloEscolar=@cicloEscolar
									                    group by CicloEscolar,a.IdKardexCandidato
									                    ) as Evaluados
						                    ) as B
				                    cross join (
							                    select  count(IdKardexCandidato) as TotalContratados 
							                    from (
								                       select CicloEscolar,a.IdKardexCandidato
									                    from Kardex_SolicitudEvaluaciones a
									                    inner join Kardex_SolicitudEvaluacionesEstatus c on c.IdKardexSolicitudEvaluacion=a.IdKardexSolicitudEvaluacion
									                    inner join Catalogos_ctEstatusContratos d on d.IdEstatusContratos=c.IdEstatusContratacion
									                    where a.IdRelacionLaboral=1 and  d.EstatusContratos in ('CONTRATADO') and a.CicloEscolar=@cicloEscolar
									                    group by CicloEscolar,a.IdKardexCandidato
								                    ) as Contratados
							                    ) as C
                            ";
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            DatosAvance datos = (DatosAvance)dp.connection.QuerySingle<DatosAvance>(query);
            dp.Close();
            return datos;
        }

        public DatosAvance ObtenDatosAvance() 
        {
            bdNovaEntities bd = new bdNovaEntities();
            var config = bd.Nomina_ContratosConfiguracion.Where(a => a.EsVigente == true).FirstOrDefault();
            string query = $@"
                  declare @cicloEscolar as nvarchar(10) 
                    set @cicloEscolar='{config.CicloEscolar}'
                    select CicloEscolar,Universo,TotalEvaluados,TotalContratados
                    ,PorcentajeEvaluados= cast(case when TotalEvaluados > 0 then (cast(TotalEvaluados as decimal)/cast(Universo as decimal))*100 else 0 end as decimal(18,2))
                    ,PorcentajeContratados=cast(case when TotalContratados > 0 then (cast(TotalContratados as decimal)/cast(Universo as decimal))*100 else 0 end as decimal(18,2))
                    from 
                        (select CicloEscolar, 
			                    count(*) as Universo
			                    from Kardex_SolicitudEvaluaciones
			                    where CicloEscolar=@cicloEscolar
			                    group by CicloEscolar) as A
				                    cross join (
							                    select count(IdKardexCandidato) as TotalEvaluados 
								                    from (
									                    select CicloEscolar,a.IdKardexCandidato
									                    from Kardex_SolicitudEvaluaciones a
									                    inner join Kardex_SolicitudEvaluacionesEstatus c on c.IdKardexSolicitudEvaluacion=a.IdKardexSolicitudEvaluacion
									                    inner join Catalogos_ctEstatusContratos d on d.IdEstatusContratos=c.IdEstatusContratacion
									                    where d.EstatusContratos in ('NO ACEPTABLE','ACEPTABLE') and a.CicloEscolar=@cicloEscolar
									                    group by CicloEscolar,a.IdKardexCandidato
									                    ) as Evaluados
						                    ) as B
				                    cross join (
							                    select  count(IdKardexCandidato) as TotalContratados 
							                    from (
								                       select CicloEscolar,a.IdKardexCandidato
									                    from Kardex_SolicitudEvaluaciones a
									                    inner join Kardex_SolicitudEvaluacionesEstatus c on c.IdKardexSolicitudEvaluacion=a.IdKardexSolicitudEvaluacion
									                    inner join Catalogos_ctEstatusContratos d on d.IdEstatusContratos=c.IdEstatusContratacion
									                    where d.EstatusContratos in ('CONTRATADO') and a.CicloEscolar=@cicloEscolar
									                    group by CicloEscolar,a.IdKardexCandidato
								                    ) as Contratados
							                    ) as C
                            ";
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            DatosAvance datos = (DatosAvance) dp.connection.QuerySingle<DatosAvance>(query);
            dp.Close();
            return datos;
        }

        public List<DatosGraficas> ObtenDatosPorTipoRelacion()
        {
            bdNovaEntities bd = new bdNovaEntities();

            var config = bd.Nomina_ContratosConfiguracion.Where(a => a.EsVigente == true).FirstOrDefault();



            string query = $@"
                     select f.RelacionLaboral as Etiqueta,count(b.Sexo) as Valor
                        from Kardex_SolicitudEvaluaciones a
                        inner join vwDatosAspirantesTrabajadores b on a.IdKardexCandidato=b.IdKardex and a.CicloEscolar='{config.CicloEscolar}'
                        inner join Kardex_ctAreaConocimiento c on a.IdAreaConocimiento=c.IdAreaConocimiento
                        inner join Plazas_ctCategoria bb on bb.IdCategoria=a.IdCategoriaAspirante
                        inner join Convenios_stRelacionConvenioLaboral d on d.IdRelacionConvenioLaboral=bb.IdRelacionConvenioLaboral
                        inner join Catalogos_ctConvenioLaboral e on e.IdConvenioLaboral=d.IdConvenioLaboral
                        inner join Catalogos_ctRelacionLaboral f on f.IdRelacionLaboral=d.IdRelacionLaboral
                        group by f.RelacionLaboral
                        order by 2 desc
                          ";


            DapperQuery dp = new DapperQuery("bdNovaEntities");



            List<DatosGraficas> datos = (List<DatosGraficas>)dp.connection.Query<DatosGraficas>(query.ToString()).ToList().AsEnumerable();

            dp.Close();
            return datos;

        }

        public List<DatosGraficas> ObtenDatosPorGenero()
        {
            bdNovaEntities bd = new bdNovaEntities();

            var config = bd.Nomina_ContratosConfiguracion.Where(a => a.EsVigente == true).FirstOrDefault();



            string query = $@"select case when b.Sexo='H' then 'HOMBRE' else 'MUJER' END  as Etiqueta,count(b.Sexo) as Valor
                        from Kardex_SolicitudEvaluaciones a
                        inner join vwDatosAspirantesTrabajadores b on a.IdKardexCandidato=b.IdKardex and a.CicloEscolar='{config.CicloEscolar}'
                        inner join Kardex_ctAreaConocimiento c on a.IdAreaConocimiento=c.IdAreaConocimiento
                        inner join Plazas_ctCategoria bb on bb.IdCategoria=a.IdCategoriaAspirante
                        inner join Convenios_stRelacionConvenioLaboral d on d.IdRelacionConvenioLaboral=bb.IdRelacionConvenioLaboral
                        inner join Catalogos_ctConvenioLaboral e on e.IdConvenioLaboral=d.IdConvenioLaboral
                        inner join Catalogos_ctRelacionLaboral f on f.IdRelacionLaboral=d.IdRelacionLaboral
                               group by b.Sexo
                        order by 2 desc
                          ";


            DapperQuery dp = new DapperQuery("bdNovaEntities");



            List<DatosGraficas> datos = (List<DatosGraficas>)dp.connection.Query<DatosGraficas>(query.ToString()).ToList().AsEnumerable();

            dp.Close();
            return datos;

        }
    }
}